---
description: "Learn more about: Logical functions"
title: "Logical functions (DAX) | Microsoft Docs"
---
# Logical functions

Logical functions act upon an expression to return information about the values or sets in the expression. For example, you can use the IF function to check the result of an expression and create conditional results.  
  
## In this category

|Function  |Description  |
|---------|---------|
|[AND](and-function-dax.md)      | Checks whether both arguments are TRUE, and returns TRUE if both arguments are TRUE.      |
|[BITAND](bitand-function-dax.md)      | Returns a bitwise 'AND' of two numbers.      |
|[BITLSHIFT](bitlshift-function-dax.md)      | Returns a number shifted left by the specified number of bits.       |
|[BITOR](bitor-function-dax.md)      | Returns a bitwise 'OR' of two numbers.       |
|[BITRSHIFT](bitrshift-function-dax.md)      | Returns a number shifted right by the specified number of bits.         |
|[BITXOR](bitxor-function-dax.md)      | Returns a bitwise 'XOR' of two numbers.        |
|[COALESCE](coalesce-function-dax.md)|Returns the first expression that does not evaluate to BLANK.|
|[FALSE](false-function-dax.md)      | Returns the logical value FALSE.         |
|[IF](if-function-dax.md)      | Checks a condition, and returns one value when TRUE, otherwise it returns a second value.        |
|[IF.EAGER](if-eager-function-dax.md)      | Checks a condition, and returns one value when TRUE, otherwise it returns a second value. Uses an *eager* execution plan which always executes the branch expressions regardless of the condition expression.        |
|[IFERROR](iferror-function-dax.md)      |  Evaluates an expression and returns a specified value if the expression returns an error       |
|[NOT](not-function-dax.md)     | Changes FALSE to TRUE, or TRUE to FALSE.          |
|[OR](or-function-dax.md)     |  Checks whether one of the arguments is TRUE to return TRUE.       |
|[SWITCH](switch-function-dax.md)      | Evaluates an expression against a list of values and returns one of multiple possible result expressions.          |
|[TRUE](true-function-dax.md)      |  Returns the logical value TRUE.         |
